#!/usr/bin/perl -w
use strict;

use FindBin;
use lib "$FindBin::Bin/lib";
use Utils::Common;
use Utils::Hosts qw(get_crontab_files);
use Utils::Sys qw(
    print_err
    handle_errors
);
use Getopt::Long;


handle_errors();

my %opt = (
);
GetOptions(
    \%opt,
    'print',
    'check',
    'check_light',
    'set',
    'help',
);

if ($opt{help}) {
    printf "set-crontab.pl - set crontab from svn or check if the actual crontab is setted\n";
    printf "  --set             Set crontab for bmclient from svn\n";
    printf "  --print           Only print crontab from svn to STDOUT\n";
    printf "  --check           Check if actual crontab is setted. Exit code is 0 if crontab from svn matches with 'crontab -l'; 1 otherwise.\n";
    printf "  --check_light     Check if actual crontab is setted. Exit code is 0 if all svn crontab lines are in 'crontab -l'; 1 otherwise.\n";
    printf "  --help\n";
    exit(0);
}

if (@ARGV) {
    die "Unknown options: " . join(" ", map {"'$_'"} @ARGV);
}

my @crontabs = @{ get_crontab_files() || [] }; # TODO warn if get_crontab_files returned void 
print_err("crontab files: " . join(" ", @crontabs));

my $sudo_bmclient_if_need = (`whoami` eq "bmclient\n") ? "" : "sudo -u bmclient";

if ($opt{print}) {
    for my $file (@crontabs) {
        if ( ! -f $file ) {
            die "File does not exits: $file";
        }
        open my $fh, $file
            or die "Could not open $file ($!)";
        print   while (<$fh>);
        close $fh
            or die "Could not open $file ($!)";
    }
    exit(0);
} elsif ($opt{check} || $opt{check_light}) {
    print_err("Check crontab diff ...");
    my @crontab_svn;
    for my $file (@crontabs) {
        open my $fh, "< $file"  or die "Could not open $file ($!)";
        while (<$fh>) {
            push @crontab_svn, $_;
        }
        close $fh, "< $file"  or die "Could not close $file ($!)";
    }
    my @crontab_real = `$sudo_bmclient_if_need crontab -l`;

    @crontab_svn  = grep { m/[^\s]/  and  not m/^\s*#/ } @crontab_svn;
    @crontab_real = grep { m/[^\s]/  and  not m/^\s*#/ } @crontab_real;
    my %crontab_svn  = map { $_ => 1 } @crontab_svn;
    my %crontab_real = map { $_ => 1 } @crontab_real;
    my @added = grep { not $crontab_svn{$_} } @crontab_real;
    my @deleted = grep { not $crontab_real{$_} } @crontab_svn;

    my $is_ok = 1;
    if (@deleted) {
        $is_ok = 0;
        print_err("Error: Some crontab lines have been deleted!");
        print_err("  $_")  for map { chomp; $_ } @deleted;
    }
    if ($opt{check} and @added) {
        $is_ok = 0;
        print_err("Error: Some crontab lines have been added!");
        print_err("  $_")  for map { chomp; $_ } @added;
    }
    if ($is_ok) {
        print_err("Crontab is ok");
    }
    exit($is_ok ? 0 : 1);
} elsif ($opt{set}) {
    # set-crontab.pl --set  используется в ansible. Изменение формата согласовать с админами
    print_err("setting crontab ...");
    if (@crontabs) {
        system("cat @crontabs | $sudo_bmclient_if_need crontab -") == 0
            or die "Set crontab failed: $!";
        print_err("ok");
    } else {
        print_err("WARN: no crontabs found!");
    }
} else {
    die "Unknown options! See  set-crontab.pl --help  for details. (Use '--set' option to set crontab for bmclient)";
}

exit(0);

