#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;

use BaseProject;

use Utils::Sys qw/md5int/;

use YtProjectLaunchHelper;

my $proj = BaseProject->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

my $helper = YtProjectLaunchHelper->new({});
my $cfg = $helper->load_job_cfg_yt;

while (my $line = <STDIN>) {
    chomp($line);
    my @fields_arr = split /\t/, $line;
    my $fields;
    foreach my $field ( @fields_arr ) {
        my ($key, $value) = split /=/, $field, 2;
        $fields->{$key} = $value;
    }
    my $result = {};
    if ( $cfg->{input}{text} ) {
        my $phr = $proj->phrase($fields->{$cfg->{input}{text}});
        $result = process_text($phr, $cfg);
    }
    else {
        my $bnr_data = {};
        foreach my $field ( keys %{$cfg->{input}} ) {
            $bnr_data->{$field} = $fields->{$cfg->{input}{$field}};
        }
        my $bnr = $proj->bf->lbanner($bnr_data);
        $result = process_banner($bnr, $cfg);
    }
    print join("\t",
        $line,
        join("\t",
            map {$_ ."=". $result->{$_}} keys %$result,
        ),
    ), "\n";
}

sub process_text {
    my ( $phr, $cfg ) = @_;
    my $result = {};
    foreach my $field ( @{$cfg->{output}} ) {
        if ( $field eq 'categories' ) {
            $result->{categories} = join '/',$phr->get_minicategs;
        }
        if ( $field eq 'flags' ) {
            $result->{flags} = join ',', $phr->get_banner_catalogia_flags;
        }
        if ( $field eq 'directids' ) {
            $result->{directids} = join ',', $phr->get_minicategs_videodirectgroups_directids;
        }
        if ( $field eq 'directcatids' ) {
            $result->{directcatids} = join ',', $phr->get_minicategs_directids;
        }
        if ( $field eq 'catids' ) {
            $result->{catids} = join ',', grep{$_} map{$phr->proj->categs_tree->get_minicateg_id($_)} $phr->get_minicategs;
        }
        if ( $field eq 'mediaids' ) {
            $result->{mediaids} = join ',', grep{$_} map{md5int($_)} $phr->get_mediagroups_for_categs([$phr->get_minicategs]);
        }
        if ( $field eq 'mediagroups' ) {
            $result->{mediagroups} = join '/', grep{$_} $phr->get_mediagroups_for_categs([$phr->get_minicategs]);
        }
    }
    if ( $cfg->{bmapi} ) {
        my $phl = $phr->proj->phrase_list([$phr]);
        foreach my $cmd ( @{$cfg->{bmapi}} ) {
            if ((my $method = $phl->can($cmd)) && ($phl->can_be_externally_used($cmd, "yt"))) {
                my $res_phl = $phl->$method();
                my $res_text = join '\n', map {$_->text} @$res_phl; # '\n' is singlequoted on purpose, for correct output
                $result->{$cmd} = $res_text;
            } else {
                die "Unsupported bmapi method";
            }
        }
    }
    return $result;
}

sub process_banner {
    my ( $bnr, $cfg ) = @_;
    my $result = {};
    foreach my $field ( @{$cfg->{output}} ) {
        if ( $field eq 'categories' ) {
            $result->{categories} = join '/',$bnr->get_minicategs;
        }
        if ( $field eq 'flags' ) {
            $result->{flags} = join ',', $bnr->get_catalogia_flags;
        }
        if ( $field eq 'directids' ) {
            $result->{directids} = join ',', $bnr->get_minicategs_videodirectgroups_directids;
        }
        if ( $field eq 'directcatids' ) {
            $result->{directcatids} = join ',', $bnr->get_minicategs_directids;
        }
        if ( $field eq 'catids' ) {
            $result->{catids} = join ',', grep{$_} map{$bnr->proj->categs_tree->get_minicateg_id($_)} $bnr->get_minicategs;
        }
        if ( $field eq 'mediaids' ) {
            $result->{mediaids} = join ',', grep{$_} map{md5int($_)} $bnr->preprocess_title_body->get_mediagroups_for_categs([$bnr->get_minicategs]);
        }
        if ( $field eq 'mediagroups' ) {
            $result->{mediagroups} = join '/', grep{$_} $bnr->preprocess_title_body->get_mediagroups_for_categs([$bnr->get_minicategs]);
        }
    }
    return $result;
}
