#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

my $lock_name = "subphraser-start-server" . ($ARGV[0] || "");

get_file_lock($lock_name) or print_err("found already running script, do exit") and exit(0);

handle_errors;

my $proj = Project->new({});
my $client = $proj->{$ARGV[0] || "subphrases_client"};

die("bad client name '$ARGV[0]'") if !$client;

# если файла с данными нет, выходим
unless(-e $client->init_data_file) {
    $proj->log("no data file, do exit");
    exit(0);
}

# запуск сервера
$proj->do_sys_cmd(join " ",
    "LD_PRELOAD=\"/usr/lib/libtcmalloc_minimal.so.4\"",
    $client->dir_server."/subphraser", 
    "--port=".$client->port,
    "--exec-file=".$client->init_data_file
);

release_file_lock($lock_name) or print_err("found already running script, do exit") and exit(0);

