#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
    get_runlevel
/;
use Utils::Server  qw(start_server);


handle_errors;

my $proj = Project->new({});

my %opts = map{$_ => 1} @ARGV;

my $pid_file = join("", $Utils::Common::options->{dirs}{lock}, "/subphraser.pid");
my $log_file = join("", $Utils::Common::options->{dirs}{log}, "/subphraser.log");
start_server($pid_file, $log_file);

# запуск сервера
$proj->do_sys_cmd(join " ",
    $proj->subphrases_client->dir_server."/subphraser", 
    "--port=".$proj->subphrases_client->port,
    "--exec-file=".$proj->subphrases_client->init_data_file
);

