#!/usr/bin/perl -w

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../wlib";
use CatalogiaMediaProject;
use Utils::Sys qw/
    get_file_lock release_file_lock
    print_log
    print_err
    handle_errors
/;

get_file_lock("subphraser-update-from-db") or print_err("found already running script, do exit") and exit(0);

handle_errors;

my $proj = CatalogiaMediaProject->new({ no_auth => 1, no_form => 1 });

# остановка сервера
$proj->log("update_from_db");
my $phrases = $proj->List_SQL("
    select * from CatalogiaPhrases 
    where 
        Status != 'Declined' and 
        (Status != 'Done' or UpdateTime > date_sub(now(), interval 1 day)) 
    order by UpdateTime
");
for my $phr (@$phrases) {
    my @a = map{$phr->{$_}} qw(CatID InitialPhrase Action Language Status);
    $proj->log("updating (" . join(" / ", @a) . ")");
    s/\t/ /g for @a;
    $proj->update_subphraser(@a);
}
$proj->log("/ update_from_db");

release_file_lock("subphraser-update-from-db");

