#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/lib";
use lib "$FindBin::Bin/wlib";

use Utils::Common;
use Utils::Sys qw(
    get_file_lock release_file_lock
    fork_tasks
    rotate_files
    handle_errors
);

use Project;
use CatalogiaMediaProject;
use Cmds::Moderation;
use Data::Dumper;


get_file_lock() or exit(0);
handle_errors();

my $proj = CatalogiaMediaProject->new({
    no_auth => 1,
    no_form => 1,
});

my $send_time = '17:00:00';
my $prev_date = $proj->dates->cur_date('db', -24 * 3600) . " $send_time";
my $curr_date = $proj->dates->cur_date('db') . " $send_time";

my $phrases = $proj->user_phrases->List([
    ['Action' => ['Add', 'Delete']],
    ['CreateTime' => '>=' => $prev_date],
    ['CreateTime' => '<' => $curr_date],
    ['Status' => '!=' => 'Declined'],
]);
my %cat_id_to_phrases = ();
push @{$cat_id_to_phrases{$_->{CatID}}}, $_ for @$phrases;

my $subscriptions = $proj->category_subscriptions->List([]);
my %login_to_cat_ids = ();
$login_to_cat_ids{$_->{Login}}->{$_->{SubscriptionType}}->{$_->{CatID}} = 1 for @$subscriptions;

for my $subscriber (keys %login_to_cat_ids) {
    my @act_phrases = ();
    for my $cat_id (keys %cat_id_to_phrases) {
        if ($login_to_cat_ids{$subscriber}->{Single}->{$cat_id}) {
            push @act_phrases, @{$cat_id_to_phrases{$cat_id}};
            next;
        }
        my $parent_id = $cat_id;
        while ($parent_id) {
            if ($login_to_cat_ids{$subscriber}->{Full}->{$parent_id}) {
                push @act_phrases, @{$cat_id_to_phrases{$cat_id} || []};
                last;
            }
            $parent_id = $proj->get_parent_id($parent_id);
        }
    }
    $_->{InitialPhrase} =~ s/</&lt;/g for @act_phrases;
    $_->{InitialPhrase} =~ s/>/&gt;/g for @act_phrases;
    my $subscriber_email = $proj->catalogia_users->Get($subscriber)->{'EMail'};
    @act_phrases = grep {$_->{Login} ne $subscriber} @act_phrases;
    next if !$subscriber_email || !@act_phrases;
    # next if $subscriber ne 'kirill-samelyuk';
    $proj->log("sending to $subscriber_email");
    my $sendmail = "/usr/sbin/sendmail -t";
    # my $moderator_email = $moderator_object->{EMail};
    my $send_from = "From: no_reply\@yandex-team.ru \n";
    my $subject = "Subject: CatMedia Subscriptions\n";
    my $send_to = "To: $subscriber_email\n";
    # my $copy_to = "CC: ksamelyuk\@yandex-team.ru\n";

    open(SEND, "|$sendmail") or die "Cannot open $sendmail: $!";
    print SEND $send_from;
    print SEND $subject;
    print SEND $send_to;
    # print SEND $copy_to;
    print SEND "Content-type: text/html; charset=UTF-8\n\n";
    print SEND "Добрый день!<br><br>В категориях, на которые Вы подписаны, произошли следующие изменения:<br><br>";
    print SEND get_html_table($proj, \@act_phrases); 
    close(SEND);   
    
}

$phrases = $proj->user_phrases->List([
    ['CreateTime'   => '>=' => $prev_date],
    ['CreateTime'   => '<' => $curr_date],
    ['Status'       => '!=' => 'Declined'],
]);

my @filters = @{$proj->dbtable('SubscriptionsFilters', 'ID')->List()};
my %subscriber2filters = ();
push @{$subscriber2filters{$_->{Subscriber}}}, JSON::from_json($_->{Filter}) for @filters;

for my $subscriber (keys %subscriber2filters) {
    my $filter_index = 0;
    my %cat_ids_hash = map {
        $_ => 1
    } map {
        @{$proj->category_interface->get_categories_containing_flag($_)}
    } map {
        @{$_->{InitialPhrase}}
    } @{$subscriber2filters{$subscriber}};
    my $filters = { 0 => {CatID => [keys %cat_ids_hash]} };
    my $filtered_phrases = $proj->filters($filters)->grep_list($phrases);
    next if !@$filtered_phrases;
    my $subscriber_email = ($proj->catalogia_users->Get($subscriber) || {})->{'EMail'};
    next if !$subscriber_email;
    my $html_table = get_html_table($proj, $filtered_phrases);
    $proj->SendMail({
        from    => 'no_reply@yandex-team.ru',
        to      => "$subscriber_email",
        subject => 'CatMedia Subscriptions',
        body    => "$html_table",
        type    => 'text/html',
    });
}

release_file_lock();

sub make_html_header_row {
    my $row = "<tr>\n";
    @_ = map{"<th>" . ($_ || "&nbsp;") . "</th>\n"} @_;
    $row .= (join '', @_);
    $row .= "</tr>\n";
    return $row;
}

sub make_html_row {
    my $row = "<tr>\n";
    @_ = map{"<td>" . ($_ || "&nbsp;") . "</td>\n"} @_;
    $row .= (join '', @_);
    $row .= "</tr>\n";
    return $row;
}

sub get_html_table {
    my ($proj, $phrases) = @_;
   
    my $table .= "<table border='1'>\n";
    $table .= make_html_header_row('Категория', 'Действие', 'Фраза', 'Пользователь');
    for my $phr (@$phrases) {
        my ($cat_id, $action, $initial_phrase, $login) = ($phr->{CatID}, $phr->{Action}, $phr->{InitialPhrase}, $phr->{Login});
        my $category_url = get_category_url($proj, $cat_id);
        $table .= make_html_row($category_url, $action, $initial_phrase, $login);
    }
    $table .= "</table><br><br><br>\n";
    
    return $table;
}

sub get_category_url {
    my ($proj, $cat_id) = @_;
    my $cat_name = $proj->get_category_name($cat_id);

    return "<a href=\"http://catmedia.yandex.ru/ind.pl?cmd=show_phrases&id=$cat_id&viewoptionsstr=lang_ru\">$cat_name</a>" .
            "(" .
            "<a href=\"http://catmedia.yandex.ru/ind.pl?cmd=show_phrases&id=$cat_id&viewoptionsstr=lang_ru\">$cat_id</a>" .
            ")";
}
