#! /usr/bin/perl -w

use strict;
use utf8;
 
use open ":utf8";
no warnings "utf8";

binmode (STDIN, ":utf8");
binmode (STDOUT, ":utf8");
binmode (STDERR, ":utf8");

use Data::Dumper;

$Data::Dumper::Useqq = 1;
{ 
    no warnings 'redefine';
    sub Data::Dumper::qquote {
        my $s = shift;
        return "'$s'";
    }
}

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../cpan";
use lib "$FindBin::Bin/../wlib";
use Utils::Sys qw[ get_file_lock release_file_lock handle_errors ];
use CatalogiaMediaProject;
use BM::SolomonClient;

get_file_lock() or exit(0);
handle_errors();

my $proj = CatalogiaMediaProject->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
    use_comptrie_subphraser => 1,
    no_form => 1,
    no_auth => 1,
});

my @errors = ();
$proj->log("find_banners_benchmark_categs_diff: STARTS");

$proj->log("find_banners_benchmark_categs_diff: cleaning BannersTaggingBenchmarkForReview table");
$proj->Do_SQL("DELETE FROM BannersTaggingBenchmarkForReview"); 
$proj->log("find_banners_benchmark_categs_diff: cleaning BannersTaggingBenchmarkForReview table done");

# Проверяем изменение категоризации по всем баннерам в эталоне
my @ids_and_elems_id = @{$proj->List_SQL("select ID, CategoriesString, CategPhrases, UpdateTime, BannerID, bid, Data, Lang, ChangesHistory from BannersTaggingBenchmark")};

$proj->log("find_banners_benchmark_categs_diff: ".(scalar @ids_and_elems_id)." elements found in BannersTaggingBenchmark, starting updating");
for my $t (@ids_and_elems_id) {
    #print "t data:\n", Dumper($t);
    $proj->log("find_banners_benchmark_categs_diff: updating item BenchmarkID = ".($t->{ID}));
    my $h = @{$proj->deserial($t->{Data})}[0];
    my $prevlang = $proj->current_lang;
    my $new_lang = $t->{Lang};
    
    $proj->current_lang($new_lang);
    $h->{proj} = $proj;
    $h->{lang} = $new_lang;

    #TODO: проверить и починить для en и tr категоризации
    my $bnl = $proj->bf->banner_list( [ $h ] );

    for my $bnr ( @$bnl ) {
        my @categsNew = sort $bnr->get_minicategs;
        my @categsOld = sort split /\//, $t->{CategoriesString};

        unless (@categsOld ~~ @categsNew) {
            my $categPhrasesNew = [ map {{ category => $_->[0], phrase => $_->[1], }} map { @$_ } $bnr->get_categs_phrases ];
 
            my $w;
            $w->{BenchmarkID} = $t->{ID}; 
            # если в таблице для ревью уже есть запись с таким BenchmarkID, то мы её удаляем
            $proj->Do_SQL("delete from BannersTaggingBenchmarkForReview where BenchmarkID = ".($w->{BenchmarkID}));

            $w->{CategoriesStringOld} = $t->{CategoriesString};
            $w->{CategPhrasesOld} = $t->{CategPhrases};
            $w->{CategoriesStringNew} = join '/', @categsNew;
            $w->{CategPhrasesNew} = $proj->serial($categPhrasesNew);
            $w->{ChangesHistory} = $t->{ChangesHistory};
            $w->{$_} = '' for (qw(Action ManualCategory));
            $w->{$_} = $t->{$_} for (qw(UpdateTime BannerID bid Data Lang));

            my $dbt_tsb = $proj->dbtable('BannersTaggingBenchmarkForReview');
            $dbt_tsb->Add([ $w ]);
            $proj->log("find_banners_benchmark_categs_diff: updating item BenchmarkID = ".($t->{ID})." changes in categorisation found");
        }
    }
    $proj->current_lang($prevlang);
    $proj->log("find_banners_benchmark_categs_diff: updating item BenchmarkID = ".($t->{ID})." DONE");
}

my @data_for_review = @{$proj->List_SQL("select ID from BannersTaggingBenchmarkForReview")};
$proj->log("find_banners_benchmark_categs_diff: table BannersTaggingBenchmarkForReview has been updated, found ".(scalar @data_for_review)." items to review");
if (@data_for_review) {
    # есть изменения, посылаем письмо с просьбой их просмотреть
    my $path = "https://catmedia.yandex.ru/cgi/ind.pl?cmd=banners_tagging_benchmark_categs_diff";

    my $text = '';
    $text .= "В эталоне категоризации баннеров произошли изменения.\n"
           . "Пожалуйста, ознакомьтесь с ними и выберите наиболее подходящий вариант категоризации:\n$path\n";
    $text .= "\n\nЭто письмо сформировано автоматически. Пожалуйста, не отвечайте на него.\n";
    $text .= 'Если у Вас возникли вопросы о полученном письме, Вы можете написать по адресу kuzinaksu@yandex-team.ru  ';

    my $res = $proj->SendMail({
        from => 'no_reply@yandex-team.ru', 
        mail_list => "banners_benchmark",
        subject => "Изменение категоризации баннеров эталона",
        body => $text,
    });

    if ($res) {
        $proj->log("find_banners_benchmark_categs_diff: the letter has been sent successfully");
    } else {
        push @errors, "can't send the letter"; 
    }
}

if (@errors) {
    $proj->log("WARN: ERRORS WERE FOUND: ".(join ", ", @errors));
}
else {
    $proj->log("FIND_BANNERS_BENCHMARK_CATEGS_DIFF_OK");
    BM::SolomonClient->new()->set_success_script_finish("find_banners_benchmark_categs_diff");
}
release_file_lock();
exit(0);
