#!/usr/bin/env perl
use strict;
use warnings;

use utf8;
use open ':utf8';

use Test::More;

use FindBin;
use lib "$FindBin::Bin/../../../lib";

use Project;
my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';

my $geoinf_eta = {
    'names'    => [
        'Актюбинская область',
        'Кызылординская область',
        'Костанайская область',
        'Карагандинская область',
        'Ерейментауский район',
        'Западно-Казахстанская область',
        'Зерендинский район',
        'Восточно-Казахстанская область',
        'Алматинская область',
        'Павлодарская область',
        'Южно-Казахстанская область',
        'Мангистауская область',
        'Акмолинская область',
        'Северо-Казахстанская область',
        'Атырауская область',
        'Бурабайский район',
        'Нижегородская область',
        'Удмуртская Республика',
        'Чукотский автономный округ',
        'Воронежская область',
        'Костромская область',
        'Республика Мордовия',
        'Камчатский край',
        'Тамбовская область',
        'Смоленская область',
        'Сахалинская область',
        'Ханты-Мансийский АО',
        'Архангельская область',
        'Алтайский край',
        'Липецкая область',
        'Приморский край',
        'Омская область',
        'Тверская область',
        'Амурская область',
        'Республика Башкортостан',
        'Хабаровский край',
        'Калининградская область',
        'Еврейская автономная область',
        'Оренбургская область',
        'Республика Калмыкия',
        'Мурманская область',
        'Курганская область',
        'Республика Марий Эл',
        'Пензенская область',
        'Свердловская область',
        'Ямало-Ненецкий АО',
        'Ульяновская область',
        'Брянская область',
        'Иркутская область',
        'Республика Кабардино-Балкария',
        'Кировская область',
        'Псковская область',
        'Республика Тыва',
        'Ярославская область',
        'Калужская область',
        'Москва и Московская область',
        'Тульская область',
        'Республика Татарстан',
        'Томская область',
        'Забайкальский край',
        'Белгородская область',
        'Республика Бурятия',
        'Республика Коми',
        'Ненецкий автономный округ',
        'Республика Карелия',
        'Волгоградская область',
        'Орловская область',
        'Саратовская область',
        'Чувашская Республика',
        'Самарская область',
        'Пермский край',
        'Республика Алтай',
        'Ростовская область',
        'Магаданская область',
        'Республика Адыгея',
        'Владимирская область',
        'Новосибирская область',
        'Ивановская область',
        'Челябинская область',
        'Республика Саха (Якутия)',
        'Рязанская область',
        'Кемеровская область',
        'Вологодская область',
        'Крым',
        'Республика Хакасия',
        'Курская область',
        'Тюменская область',
        'Астраханская область',
        'Новгородская область',
        'Красноярский край',
        'Санкт-Петербург и Ленинградская область'
    ],
    'rule'     => 'geotargetting',
    'geo_flag' => 1
};

my BM::Banners::LBannerBM $bnr = $proj->text2banner(<DATA>);
my $geoinf = $bnr->geotargeting_region_inf();
is_deeply($geoinf, $geoinf_eta, "geotargeting_region_inf");

done_testing();

__DATA__
1008878385	13384012	79776606	Квартира Хоста куплю	Квартира Хоста куплю. От Застройщика. Акция до пятницы! Жми!		225,-239,-102444,159	квартира хоста куплю -авито -аренды -вторичка -г -застройщика -моря -недвижимость -недорого -новостройки -однокомнатную -продажа -сити -сочи -цены:0.33:32:2:157:35:1:1558519413	http://база-недвижимости.жк-сочи.рф/?utm_source=yandex&utm_medium=cpc&utm_campaign=utm_proff-produkt-x-geo-h-deystvie&roistat=direct6_{source_type}_{banner_id}_{keyword}&roistat_referrer={source}&roistat_pos={position_type}_{position}	1	706707920	5759727	dummy	база-недвижимости.жк-сочи.рф	767922025	1	0	1	0	text
