#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/lib";

use Utils::Common;
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    handle_errors
    print_err
);

handle_errors();

get_file_lock()
    or die "enumerate_categs.pl is already runned";

my $options = $Utils::Common::options;
for my $files_pair (
    [ @{$options->{MoviesCategories_params}}{qw[ categs_file_gen categs_file ]} ],
) {
    my ($file_gen, $file_svn) = @{$files_pair};
    die "Void filename!" unless ($file_svn and $file_gen);
    print_err("files: $file_gen $file_svn");

    my $file_tmp = "$file_svn.tmp";
    Utils::Sys::do_sys_cmd("cp -a $file_gen $file_tmp && mv $file_tmp $file_svn");
}

print_err("Done");

exit(0);
