#!/usr/bin/perl -w
use strict;

=pod
    Построение словаря для разваливания гео-названий
    из данных геобазы и найденных вручную исключений
    (страна, города на которые разваливаем)
    Логика примения словаря: разваливаем, если категория -- "Туризм",
    с учетом "минус-слов" ("виза", "посольство", "консульство")
=cut

use FindBin;
use lib "$FindBin::Bin/../lib";
use Utils::Common;
use geobaselite;

use utf8;
use open ":utf8";

my $exdict = $Utils::Common::options->{dirs}{dicts}.'/dict_geo_exclusions';
my ($output) = @ARGV;

my (%townid, %countryid, %regname, $RUS_regid, $SNG_regid);
while (my ($id, $reg) = each %geobaselite::Region) {
    my $name = $reg->{name};
    $RUS_regid = $id if $name eq 'Россия';
    $SNG_regid = $id if $name eq 'СНГ';
    $countryid{$name} = $id if $reg->{type} == 3;
    $townid{$name} = $id if $reg->{type} == 6;
    $regname{$id} = $name;
}

my (%exclude, %exclude_town);
open EX, "< $exdict"  or die("can't open $exdict");
while (<EX>) {
    chomp;
    my ($country, $towns) = split ' ';
    if ($towns =~ /\*/) {
	$exclude{$country} = 1;
	next;
    }
    for my $town (split /,\s*/, $towns) {
	$exclude_town{$town} = 1;
    }
}
close EX;

open OUT, ">", $output;
for my $id (sort { $regname{$a} cmp $regname{$b} } keys %geobaselite::Region) {
    my $name = $regname{$id};
    next unless $geobaselite::Region{$id}{type} == 3;
    next if &child($id, $RUS_regid) or &child($id, $SNG_regid);
    next if $exclude{$name};
    next if $name =~ /[\s-]/;
    my @child;
    for my $town_id (@{$geobaselite::Region{$id}{chld}}) {
	my $town_name = $regname{$town_id};
	next if $town_name eq $name;
	next if $exclude_town{$town_name};
	next if $geobaselite::Region{$town_id}{type} != 6;
	next if $town_name =~ /[\s-]/;
	push @child, $town_name;
    }
    next unless @child;
    print OUT $name, "\t", join(",", sort @child), "\n";
}
close OUT;

exit(0);

sub child {
    my ($id, $parent) = @_;
    return 1 if $id == $parent;
    return 1 if grep { $_ == $parent } @{$geobaselite::Region{$id}{path}};
    return 0;
}
