#!/usr/bin/perl -w

# Пишет роль хоста (в соответствии с Hosts.pm) в файл /opt/broadmatching/work/host_role.
# Нужно для хостов в runtime

use strict;

use utf8;
use open ':utf8';

use Data::Dumper;
use Getopt::Long;
use JSON qw(to_json);

use FindBin;
use lib "$FindBin::Bin/lib";

use Project;
use Utils::Sys qw(
    handle_errors
    print_log
    print_err
);
use Utils::Hosts qw(get_host_info);

handle_errors();

my %opt;
GetOptions(
    \%opt,
    'help|h',
);
if ($opt{help}) {
    my $host_info_files = $Utils::Common::options->{host_info_files};
    print  "Prints host info to files (" . to_json($host_info_files) . ")\n";
    print  "Usage: $0\n";
    exit(0);
}

my $proj = Project->new();
update_host_info_files($proj);

exit(0);

sub update_host_info_files {
    my ($proj) = @_;

    print_err("update_host_info_files ...");

    my $host_info = get_host_info;
    print_err("host_info: " . to_json($host_info));
    my $host_info_files = $Utils::Common::options->{host_info_files};
    for my $key (sort keys %$host_info) {
        if (my $file = $host_info_files->{$key}) {
            print_err("key: $key file: $file");
            my $value = $host_info->{$key} // '';
            my $prev_value = -f $file ? $proj->file($file)->text : '';
            if ($prev_value ne $value  or  not -f $file) {
                $proj->file($file)->save($value."\n");
                # TODO: в save() делать die, если ошибка в close
            }
        }
    }

    print_err("update_host_info_files done");
    return 1;
}
