#!/usr/bin/perl -w
use strict;
use FindBin;
use lib "$FindBin::Bin/lib";
use Utils::Sys qw[
    do_sys_cmd
    get_file_lock
    handle_errors
    print_err
];
use Utils::Common;
handle_errors();
get_file_lock or die "already run, second instance stopped";
my $SERVER_SECRETS_DIR = $Utils::Common::options->{secrets}{server_dir}; chop $SERVER_SECRETS_DIR;
my $SECRETS_DIR = $Utils::Common::options->{dirs}{root}."secrets";
my $TMPDIR = $Utils::Common::options->{dirs}{temp};
my $SECRETS = $Utils::Common::options->{secrets}->{items};
my $SECRETS_ID = $Utils::Common::options->{secrets}->{id};
my $YA = $Utils::Common::options->{ya_path};

# Создаём папку с секретами, подгружаем её к нужным симлинкам
umask 0027;
do_sys_cmd("rm -rf $SECRETS_DIR") unless(-l $SECRETS_DIR); # пока безусловно требуем симлинк
unless (-d $SERVER_SECRETS_DIR) {
    mkdir($SERVER_SECRETS_DIR) or die "Can't create $SERVER_SECRETS_DIR";
};
unless (-l $SECRETS_DIR or -d $SECRETS_DIR) {
    symlink($SERVER_SECRETS_DIR,$SECRETS_DIR) or die "Can't symlink $SECRETS_DIR -> $SERVER_SECRETS_DIR";
}

# Подгружаем ключи SSH-агента (используем синтаксис C SHELL)
my $csh_script = do_sys_cmd("ssh-agent -c", read=>1); # csh easier to parse
for (split "\n", $csh_script) {
    print_err $_;
    if (/^setenv (\S+) (\S+);$/) {
        $ENV{$1} = $2;
    }
}

# Создаём папки подкатегорий секретов
for my $secret_category (keys %$SECRETS) {
    my $dir = $SECRETS_DIR . "/$secret_category";
    mkdir($dir) or die "Can't create $dir" unless (-d $dir);
}

# Добавляем в SSH-агент sudo-пользователя, от имени которого далее выгружаем секреты из Секретницы
do_sys_cmd("ssh-add");
$ENV{"SUDO_USER"}="robot-bm-admin";

for my $secret_category (keys %$SECRETS) {
    my $dir = $SECRETS_DIR . "/$secret_category";
    my $secrets_list = $SECRETS->{$secret_category}->{list};
    for my $secret (@$secrets_list) {
        if (do_sys_cmd("$YA vault get version $SECRETS_ID -o $secret >$TMPDIR$secret.tmp", no_die=>1)) {
            do_sys_cmd("mv $TMPDIR$secret.tmp $dir/$secret", no_die=>1)
            or print_err "ERROR: can't move $TMPDIR$secret.tmp -> $dir/$secret";
        }
        else {
            unlink("$TMPDIR$secret.tmp") or print_err "ERROR: can't unlink $TMPDIR$secret.tmp";
        }
    }
}
do_sys_cmd("ssh-agent -k");

# Меняем права для папок подкатегорий, а также группы-владельцов для тех ключей, которым это необходимо
for my $secret_category (keys %$SECRETS) {
    my $dir = $SECRETS_DIR . "/$secret_category";
    my $chgrp = $SECRETS->{$secret_category}->{chgrp};
    if ($chgrp) {
        for my $secret (keys %$chgrp) {
            my $grp = $chgrp->{$secret};
            do_sys_cmd("chgrp $grp $dir/$secret",
                no_die => 1,
                no_error => 1,
            );
        }
    }

    2 == chmod(0755, $SERVER_SECRETS_DIR, $dir) or die "can't chmod $dir!";
}
