#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/lib";

use Project;
use Utils::Common;
use Utils::Sys;
use Utils::Sys qw(
    handle_errors
    get_file_lock
);
use BM::Phrase;


handle_errors();

get_file_lock()
    or die "update_categories_tree_md5.pl is already runned";

my $proj = Project->new({
    load_dicts => 1,
    load_minicategs_light => 1,
});

my $temp_dir = $Utils::Common::options->{dirs}{temp};
my $categories_tree_md5 = $proj->categs_tree->compute_categories_tree_md5;
for my $file (@ARGV) {
    open (my $fh, '<', $file) or die($!);
    chomp(my $line = <$fh>);
    close $fh or die($!);

    my $temp_file = Utils::Sys::get_tempfile('', DIR => $temp_dir, UNLINK => 1);
    if ($line !~ /^CATEGORIES_TREE_MD5/) {
        $proj->do_sys_cmd_bash("echo \$'CATEGORIES_TREE_MD5\\t$categories_tree_md5' > $temp_file");
        $proj->do_sys_cmd_bash("cat $file >> $temp_file");
        $proj->do_sys_cmd_bash("mv $temp_file $file");
    } else {
        my $previous_md5 = ($line =~ /^CATEGORIES_TREE_MD5\t(.*)/)[0];
        next if $categories_tree_md5 == $previous_md5;
        $proj->do_sys_cmd_bash("echo \$'CATEGORIES_TREE_MD5\\t$categories_tree_md5' > $temp_file");
        $proj->do_sys_cmd_bash("tail -n +2 $file >> $temp_file");
        $proj->do_sys_cmd_bash("mv $temp_file $file");
    }
}
