#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/lib";
use lib "$FindBin::Bin/wlib";

use CatalogiaMediaProject;
use Utils::Common;
use Utils::Sys;
use Utils::Sys qw(
    handle_errors
    get_file_lock
);
use File::Copy;

sub tuple_to_dict {
    my ($tuple, $keys) = @_;
    die "Size mismatch" if scalar @$tuple != scalar @$keys;
    my $res = {};
    for (my $i = 0; $i < scalar @$tuple; $i++) {
        $res->{$keys->[$i]} = $tuple->[$i];
    }
    return $res;
}

sub cast_fields {
    my ($dict, $casts) = @_;
    my $res = {};
    for my $key (keys %$dict) {
        $res->{$key} = exists $casts->{$key} ? $casts->{$key}->($dict->{$key}) : $dict->{$key};
    }
    return $res;
}

handle_errors();

get_file_lock()
    or die "update_categs_tree_from_infuse.pl is already runned";

my $proj = CatalogiaMediaProject->new({
    load_dicts => 1,
    load_minicategs_light => 1,
    no_auth => 1,
    no_form => 1,
    nrmsrv => 0
});

my $temp_dir = $Utils::Common::options->{dirs}{temp};
my $temp_file_tsv = Utils::Sys::get_tempfile('', DIR => $temp_dir, UNLINK => 1);
my $result_file_tsv = $Utils::Common::options->{categs_tree_from_infuse};
my $temp_file_json = Utils::Sys::get_tempfile('', DIR => $temp_dir, UNLINK => 1);
my $result_file_json = $Utils::Common::options->{categs_tree_from_infuse_json};

open (my $fh_tsv, '>', $temp_file_tsv) or die($!);
open (my $fh_json, '>', $temp_file_json) or die($!);

my @categs_tree = $proj->categs_tree->generate_categs_tree;
print $fh_tsv join("\t", @$_)."\n" for @categs_tree;

my $keys = ['CategoryID', 'DirectID', 'DirectParentID', 'CategoryName'];
my $casts = {
    'DirectID' => sub {return int($_[0])},
    'DirectParentID' => sub {return int($_[0])},
};
print $fh_json $proj->json_obj->canonical->pretty->encode(
    [map{ cast_fields(tuple_to_dict($_, $keys), $casts) } @categs_tree]
);

close $fh_tsv;
close $fh_json;

move($temp_file_tsv, $result_file_tsv);
move($temp_file_json, $result_file_json);

exit 0;
