#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';
use Data::Dumper;

use FindBin;
use IO::Handle;
use lib "$FindBin::Bin/lib";
use lib "$FindBin::Bin/wlib";
use lib "$FindBin::Bin/cpan";

use Utils::Common;
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    handle_errors
    print_log
    do_safely
    md5int
);
use Utils::Hosts qw(
    get_curr_host
);
use CatalogiaMediaProject;
use BM::BannersMaker::Tasks::TaskQueue;

handle_errors();

my $helpformat = 'usage: update_tasks_queue_table.pl type';

my $type = $ARGV[0];
die($helpformat) unless $type;

get_file_lock("update_tasks_queue_table_$type") or exit(0);

my $proj = CatalogiaMediaProject->new({
    no_auth => 1,
    no_form => 1,
    nrmsrv  => 0,
});
my $queue = BM::BannersMaker::Tasks::TaskQueue->new({ proj => $proj, type => $type });
my $host = get_curr_host();
my $tbl_queue = $queue->queue_table;
my $tbl_monitor = $queue->monitor_table;
my %done_domains;
my @entries;

for my $work_file ($queue->get_work_files) {
    my $is_running = $queue->is_task_running($work_file);

    # обновление таблицы с очередью
    if($tbl_queue) {
        create_entry(TaskFile => $work_file, State => ($is_running ? "Processing" : "Failed"));
    }

    # обновление мониторинга
    if($tbl_monitor && !$is_running) {
        my $task_data = $queue->read_task_from_file($work_file);

        $proj->log("failed task: $work_file");

        if(!$task_data) {
            $proj->log("ERROR: can't read task from $work_file");
            next;
        }

        my $task = $proj->dyngrptask($task_data);
        $queue->update_monitor_state($task, "Fail", TaskID => "", DebugInfo => '{"no_process": 1}');
        unlink $work_file;
    }
}

# собираем информацию о тасках, которые уже обработаны, но ещё не попали в новый цикл
=h
my $done_tasks = $proj->bannerland_dbh->List_SQL("
    select Domain, Host, FinishTime, State from ".$tbl_monitor->db_table."
    inner join (
        select Domain DomainJoin, max(FinishTime) LastTime from ".$tbl_monitor->db_table." group by Domain
    ) as t on Domain=t.DomainJoin and FinishTime=t.LastTime");
for my $task (@$done_tasks) {
    next if $done_domains{$task->{Domain}} || !$task->{Host} || $task->{Host} ne $host;
    push @entries, {
        Host        => $host,
        TaskFile    => "",
        State       => $task->{State},
        Domain      => $task->{Domain},
    };
}
=cut

if($tbl_queue) {
    create_entry(TaskFile => $_, State => "New") for $queue->get_task_files;

    $tbl_queue->DelList({ Host => $host });
    $tbl_queue->Add(\@entries);
}

exit(0);

sub create_entry {
    my %h = @_;
    my $task = $queue->read_task_from_file($h{TaskFile});

    return if !$task;

    push @entries, {
        Host        => $host,
        OrderID     => $task->{OrderID} || "",
        TaskFile    => $h{TaskFile},
        State       => $h{State} || "",
        Domain      => $task->{domain} || "",
    };

    $done_domains{$task->{domain}}++;
}

