#!/usr/bin/perl
use strict;

use utf8;
use open ":utf8";

use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";

use JSON::XS;
use Getopt::Long;

use Project;

my $inapp = 0;
GetOptions(
    'inapp' => \$inapp,
);

my $proj = Project->new({load_dicts => 1, load_minicategs_light => 1, use_comptrie_subphraser => 1});

my $json_decoder = JSON::XS->new;

my $bad_file = "$FindBin::Bin/alibaba_flags";
my @bad_phrases = ();
open(FH, '<', $bad_file) or die $!;
while(<FH>){
    chomp;
    push @bad_phrases, $_;
}
my $bad_phl = $proj->phrase_list(\@bad_phrases);

print join("\t","ID","URL","Title","Price","Old Price", "Currency", "Description","Image"), "\n";

my @ids = ();

while(my $id = <STDIN>) {
    chomp $id;
    $id =~ s/(^\D*|\D*$)//g;
    die "illegal id: $id\n" if $id =~ /\D/;
    push @ids, $id;
    if (scalar(@ids) > 50) {
        process_ids(\@ids);
        @ids = ();
    }
}

if ( @ids ) {
    process_ids(\@ids);
}


sub process_ids {
    my $ids = shift;
    my $urls = [ map { "https://aliexpress.ru/item/$_.html" } @$ids];
    my $pgl = $proj->page_list($urls);
    $pgl->{enable_zora_fast} = 1;
    $pgl->zora_batch_download;
    for my $i ( 0..$#{ $ids } ) {
        process_item($ids->[$i], $pgl->[$i]);
    }
}

sub process_item {
    my ($id, $pg) = @_;
    #my $badflags_hash = $proj->perftask({})->badflags;
    my $badflags_hash = {
        adult => 1,
        underwear => 1,
        unfamily => 1,
    };
    eval {
        my $url = $pg->url;
        $pg->{enable_zora_fast} = 1;
        my $html = $pg->text;
        my $data;
        for my $str (split /\n/, $html) {
            if ($str =~ /^\s*data: {.*imagePathList/) {
                $data = $str;
                chomp $data;
                $data =~ s/^\s*data: //;
                $data =~ s/,\s*$//;
                last;
            }
        }  
        $data = $json_decoder->decode($data);

        my $quantity = 0;
        for my $skuval ( @{ $data->{skuModule}{skuPriceList} } ) {
            $quantity += $skuval->{skuVal}{availQuantity};
        }
        if (!$quantity) {
            $proj->log( "$id is not available in store!\n" );
            next;
        }

        my $descr = $data->{titleModule}{subject};
        my $descr_phr = $proj->phrase($descr);
        my @props = @{$data->{specsModule}{props}};
        my ($type) = map { $_->{attrValue} } grep {$_->{attrName} eq "Тип товара"} @props;
    
        $type ||= $data->{crossLinkModule}{breadCrumbPathList}->[-1]->{name};
    
        $type = $proj->phrase($type// "");
    
        my $orig_type = $type->orig_subphrase($descr_phr->self_phl);
        if ( scalar @$orig_type ) {
            $type = $type->set_gender_number_case($orig_type->[0]->get_gender_number_case);
        }

        $type = '' if "$type" eq 'домой';

        if ("$type" !~ /\w/ ) {
            my @words = split /\s+/, $descr;
            $type = join(' ', @words[0..5]);
        }
    
        my ($brand) = map { $_->{attrValue} } grep {$_->{attrName} eq "Название бренда"} @props;
        $brand = '' if $brand eq 'NoEnName_Null';
        $brand ||= $data->{storeModule}{storeName};
        $brand = '' if $brand eq 'NoEnName_Null';
        $brand = $proj->phrase($brand);
        $brand = $descr_phr->restore_capitalization($brand);

        my $price = $data->{priceModule}{minActivityAmount}{value};
        my $oldprice = $data->{priceModule}{minAmount}{value};
        my $currency = $data->{priceModule}{minActivityAmount}{currency};
        my $oldcurrency = $data->{priceModule}{minAmount}{currency};

        if ( !$currency || !$price ) {
            $currency = $oldcurrency;
            $price = $oldprice;
            $oldcurrency = '';
            $oldprice = '';
        }

        if ($currency ne 'RUB') {
            $price = '';
            $currency = '';
            $oldprice = '';
            $oldcurrency = '';
        }

        if ( $currency ne $oldcurrency ) {
            $oldprice = '';
            $oldcurrency = '';
        }

        my $title = "$type $brand";
        $title =~ s/(^\s*|\s*$)//g;

        my ($image) = @{ $data->{imageModule}{imagePathList} };
        if (!$image || "$type" !~ /\w/) {
            $proj->log("no data for $url");
            next;
        }

        if ($inapp) {
            #$url = 'https://aliexpress.onelink.me/X1pS?pid=yandexdirect_int&c=JVRU_CM_ALI_AND_RU_RMKT_APP_DMP_Dynrem_Perform_.lzW6bM_[[!idAd=3080381!]]&is_retargeting=true&af_click_lookback=7d&af_dp=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F' .
            #$id . '.html&af_web_dp=https%3A%2F%2Faliexpress.ru%2Fitem%2F' .
            #$id . '.html&af_ios_url=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F' .
            #$id . '.html&af_android_url=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F' .
            #$id . '.html&tracelog=yndxweb_jvru_mbag_3080381_dynrem&src=yndxweb&albch=rmkt&aff_short_key=_lzW6bM&clickid={logid}&advertising_id={google_aid}&idfa={ios_ifa}';

            #$url = 'https://aliexpress.onelink.me/X1pS?pid=yandexdirect_int&c=JVRU_CM_ALI_AND_RU_RMKT_SMART_3mlnAFFitem_DynremAND_RMP_.dX4u06r_[[!idAd=3100902!]]&is_retargeting=true&af_click_lookback=7d&af_dp=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_web_dp=https%3A%2F%2Faliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_ios_url=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_android_url=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html&tracelog=yndxweb_jvru_mbag_3100902_{gbid}_dynremand&src=yndxweb&albch=rmkt&aff_short_key=_dX4u06r&isdl=y&aff_platform=true&clickid={logid}&advertising_id={google_aid}&idfa={ios_ifa}';

            #$url = 'https://aliexpress.onelink.me/X1pS?pid=yandexdirect_int&c={campaign_name}&is_retargeting=true&af_click_lookback=7d&af_dp=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_web_dp=https%3A%2F%2Faliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_ios_url=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_android_url=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html';

            #$url = 'https://aliexpress.onelink.me/X1pS?af_force_deeplink=true&pid=yandexdirect_int&is_retargeting=true&af_click_lookback=7d&af_dp=aliexpress%3A%2F%2Fgoto%3Furl%3Dhttps%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_web_dp=https%3A%2F%2Faliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_ios_url=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html&af_android_url=https%3A%2F%2Fm.aliexpress.ru%2Fitem%2F'.
            #$id . '.html';

            $url = 'https://trk.mail.ru/c/sgtjp5?itemfeedid='.
            $id . '&regid={LOGID}&logid={LOGID}&mt_network={source_type}&mt_campaign={campaign_id}&mt_adset={gbid}&mt_creative={ad_id}&mt_sub4={phrase_id}&src=yandexmg&albch=search&albcp={campaign_id}&aff_short_key=_dTq3dj9&isdl=y&aff_platform=true&albag={gbid}&albad={ad_id}&albagn=mbag&acnt=86373530&clickid={logid}&advertising_id={google_aid}&idfa={ios_ifa}';
        }

        my $title_phr = $proj->phrase($title);
        my $descr_phr = $proj->phrase($descr);
        if ($title_phr->is_porno_phrase or $descr_phr->is_porno_phrase) {
            $proj->log("skipped porno text: $title | $descr");
            next;
        }
        my @flags = ();
        push @flags, $title_phr->get_banner_catalogia_flags;
        push @flags, $descr_phr->get_banner_catalogia_flags;

        my @badflags = grep { $badflags_hash->{$_} } @flags;
        if (@badflags) {
            $proj->log('badflags "' .join(',',@badflags). '" at: '. "$title | $descr");
            next;
        }

        my $bad_match = $bad_phl->search_subphrases_in_phrase($proj->phrase("$title $descr"));

        if (@$bad_match) {
            $proj->log('alibaba bad dict match: ' . "$bad_match" . " at: $title | $descr");
            next;
        }

        my $result = join("\t", $id, $url, $title, $price, $oldprice, $currency, $descr, $image) . "\n";
        $result =~ s/"/\\"/g;
        print $result;
    };
    if ($@) { $proj->log($@)};
}
