#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";

binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');


use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";

use Getopt::Long;
use CatalogiaMediaProject;
use Cmds::Mediaplanners;
use Data::Dumper;

my $proj = CatalogiaMediaProject->new({
    load_dicts => 1,
    load_minicategs_light => 1,
    memlog => 1,
    no_auth => 1,
    no_form => 1,
    nrmsrv => 0,
});

    $proj->categs_tree->never_write_categs_cache(1);
    $proj->categs_tree->never_read_categs_cache(1);
#$proj->dd($proj->phrase("купить квартиру")->get_atoms); exit;
my $ololo = 0;
#my $bnr = $proj->bid2banner(1940332939);
#$proj->dd($bnr->domain);
#$proj->dd($bnr->get_catalogia_flags());
#exit;
#print "-----------Ready----------\n";
#my $ololo = $proj->phrase_list(['Деревянные лестницы']);
#exit;
#$proj->optimcamp_taskproc->optimize(31919, 0 );
#exit;
#$proj->dd($proj->phrase_list(['буравчик -правило'])->search_subphrases_in_phrase($proj->phrase('правило буравчика')));
#$proj->dd($proj->phrase_list(['буравчик -правило'])->search_subphrases_in_phrase($proj->phrase('сделать буравчик')));

my %phrases = ();
while (<STDIN>) {
   chomp;
   my $bnr = $proj->bf->get_banner_by_id($_);
   next unless $bnr;
   my @categs = $bnr->get_minicategs;

   my $key = 'Фразы категорий';

   my $anal = $bnr->{analysis};
   my $analconv = {};
   for my $key (@$anal) {
       $analconv->{$key->{description}} = $key->{data};
   }

   for my $phrase (keys %{$analconv->{$key}}) {
       for my $categ ( keys $analconv->{$key}->{$phrase} ) {
           if ( $categ ~~ @categs ) {
               if (!exists $phrases{$phrase} ) {
                  $phrases{$phrase} = {};
                  $phrases{$phrase}->{phrase_info}->{phrase_categ} = $categ ;
                  my $lst = $proj->user_phrases->List([
                          [InitialPhraseID=>$proj->get_user_phrase_id($phrase)],
                      ]);

                  my $scores = $proj->dbtable('AutoModerationScores')->List([[InitialPhraseID=>$proj->get_user_phrase_id($phrase)]]);
                  my $score = shift @{$scores} || {Score => 'не найден'};
                  $phrases{$phrase}->{phrase_info}->{score} = $score->{Score};
                  $phrases{$phrase}->{phrase_info}->{user_info} = [];
                  for my $rec(@{$lst}) {
                      $phrases{$phrase}->{phrase_info}->{importance} = $rec->{Importance};
                      push @{$phrases{$phrase}->{phrase_info}->{user_info}}, {login => $rec->{Login}, action=>$rec->{Action},status=>$rec->{Status}, createtime=> $rec->{CreateTime}, updatetime => $rec->{UpdateTime}};
                  }

                  my @banner_ids = split /,/, $proj->random_banners_client->k_random_banners(30, {lang => ['ru'], mctgs => [$categ,],});
                  my @banner_samples = ();
                  for my $banner_id (@banner_ids) {
                      my $banner = $proj->bf->get_banner_by_id($banner_id);
                      next unless $banner;
                      push @banner_samples, {title => $banner->title,
                                             body => $banner->body,
                                             bid => $banner_id,
                                             phrases => [$banner->phrases],
                                             minicategs => join ("/",$banner->get_minicategs),
                                             history => join("; ", map {join ' - ' , @{$_}[0] || 'нет даты', @{$_}[1] || 'нет категории' } @{$proj->banners_categories->get_banner_history($banner_id)})
                                           };
                  }
                  $phrases{$phrase}->{sample_banners} = \@banner_samples;

               }
               push @{$phrases{$phrase}->{banners}}, [
                   {bid=> $bnr->id,
                   title=>$bnr->title,
                   body=>$bnr->body,
                   phrases=>[$bnr->phrases],
                   minicategs=>join('/',$bnr->get_minicategs)},
                   {analysis=>$analconv}
               ]
           }
       }
   }
#       my @history = @{$proj->banners_categories->get_banner_history($_)};
#
#       my @result;
#       push @result, "$_->[0]:$_->[1]" for @history;
#   print join "\t", $bnr->id || " ", $bnr->title|| " ", $bnr->body|| " ", join(",", $bnr->phrases) || " ",join("/",$bnr->get_minicategs), @result, "\n";
}

$proj->dd({$_ => $phrases{$_}}) foreach keys %phrases;
