#!/usr/bin/python
import re

import sys
import os
import shutil
import datetime
from tempfile import mkstemp

import yt.wrapper as yt

class Reducer():
    def __call__(self, key, recs):
        recs = iter(recs)
        first = next(recs)
        if first['@table_index'] != 0:
            return
        for rec in recs:
            rec.update(first)
            yield rec

def main():

    yt.config['mount_sandbox_in_tmpfs'] = True
    yt.config['token_path'] = '/opt/broadmatching/bm-tokens/yt_plato'
    yt.config['spec_defaults'] = {
        'pool': 'catalogia',
    }
    yt.config["proxy"]["url"] = "hahn.yt.yandex.net"

    yt.run_join_reduce(
        Reducer(),
        ['<primary=true>//home/advquality/direct/banner_content/go_banners/filter/banner_htmls.new', '//home/catalogia/tmp/go_ads_bid_urls'],
        '//home/catalogia/tmp/go_ads_join_urls',
        join_by='Url',
    )

if __name__ == '__main__':
    main()
