#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";

use Utils::Common;
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    fork_tasks
    rotate_files
    handle_errors
);
use Utils::Hosts qw(get_curr_host);
use Project;

get_file_lock() or exit(0);
handle_errors();

# my @hosts = qw(bmcategorize01h bmcategorize02h);

my ($chunk_id, $chunk_count) = @ARGV;
# if(!defined($chunk_id) || !defined($chunk_count)) {
#     my $host = get_curr_host();
#     for my $host_index (0..$#hosts) {
#         my $host_re = "^".$hosts[$host_index];
#         if($host =~ /$host_re/) {
#             $chunk_count = @hosts;
#             $chunk_id = $host_index + 1;
#             last;
#         }
#     }
#     die("unknown host: $host") if !defined($chunk_id);
# }

my $proj = Project->new({ load_dicts => 1, load_minicategs_light => 1, load_languages => ["en", "tr"] });
$proj->categs_tree->never_write_categs_cache(1);
$proj->categs_tree->never_read_categs_cache(1);

# рассылка писем о том, что начался очередной цикл перекатегоризации
# TODO: включить
for my $to (map{"$_\@yandex-team.ru"} qw(april-dev galeeva khromov vip-planners ksamelyuk)) {
    my $sendmail = "/usr/sbin/sendmail -t";
    my $reply_to = "From: banners-recategorized\n";
    my $subject = "Subject: Recategorization ($chunk_id / $chunk_count) has started\n";
    my $send_to = "To: $to\n";

    open(SEND, "|$sendmail") or die "Cannot open $sendmail: $!";
    print SEND $reply_to;
    print SEND $subject;
    print SEND $send_to;
    print SEND "Content-type: text/plain; charset=UTF-8\n\n";
    print SEND "current time: " . (localtime);
    close(SEND);
}

$proj->banners_categories->recategorize($chunk_id, $chunk_count);

release_file_lock();
exit(0);
