#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";

use Project;

use Utils::Common;
use Utils::Sys;

Utils::Sys::get_file_lock() or exit(0);
Utils::Sys::handle_errors();

my $proj = Project->new({});

my $temp_dir = $Utils::Common::options->{'dirs'}{'temp'};
my $temp_file = Utils::Sys::get_tempfile('', DIR => $temp_dir, UNLINK => 1);
my $url = 'https://proxy.sandbox.yandex-team.ru/last/BROADMATCH_MR_CATALOGIA?attrs={%22production%22:%221%22}';

my $tries = 5;
my $sleep_between_tries = 120;

Utils::Sys::do_safely(
    sub { Utils::Sys::do_sys_cmd("wget $url --output-document=$temp_file"); },
    tries               => $tries,
    sleep_between_tries => $sleep_between_tries,
);

Utils::Sys::do_sys_cmd("tar -xf $temp_file -C $temp_dir");

my $yt_client = $proj->yt_client;
my $yt_bin = 'YT_POOL=catalogia ' . $yt_client->get_cmd();
my $bytes_per_gigabyte = 1 << 30;
my $tmpfs_size = 8 * $bytes_per_gigabyte;
my $memory_limit = 8 * $bytes_per_gigabyte;
my $yt_command = join(' ',
    $yt_bin,
    'map',
    "'./mr_perl ./categorize_banners_451_default_yt.pl'",
    "--local-file=$temp_dir/broadmatching.tar.gz",
    "--local-file=$temp_dir/mr_perl",
    "--local-file=$temp_dir/perllibs.tgz",
    "--local-file=$Utils::Common::options->{'dirs'}{'scripts'}/banners_categories/categorize_banners_451_default_yt.pl",
    '--src=//home/catalogia/tmp/go_ads',
    '--dst=//home/catalogia/tmp/go_ads_default',
    "'--input-format=$Utils::Common::options->{'DirectClient'}{'yt_banners_format'}'",
    "'--output-format=<columns=[bid;Categories;Flags;CategoryIDs;Mediagroups;UpdateTime;pid;]>schemaful_dsv'",
    qq/'--spec={"mapper"={"tmpfs_path"="."; "copy_files"=true; "tmpfs_size"=$tmpfs_size; "memory_limit"=$memory_limit;}}'/,
);

Utils::Sys::do_safely(
    sub { Utils::Sys::do_sys_cmd($yt_command); },
    tries               => $tries,
    sleep_between_tries => $sleep_between_tries,
);

Utils::Sys::release_file_lock();
exit(0);
