#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";

use Utils::Common;
use Utils::Sys qw(
    get_file_lock
    release_file_lock
    fork_tasks
    rotate_files
    handle_errors
);
use Utils::Hosts qw(get_curr_host);
use Project;

get_file_lock() or exit(0);
handle_errors();

my $proj = Project->new({});
my $yt_client = $proj->yt_client;
my $banners_categories_params = $Utils::Common::options->{'BannersCategories_params'};
my @shards_tables = values(%{$banners_categories_params->{'shard_recategorized_table'}});
my $tmp_table = '//tmp/banners-recategorized';
my $full_table = $banners_categories_params->{'yt_table_path'} . '/banners-recategorized';
my @command = ('concatenate', (map {"--src=$_"} @shards_tables), "--dst=$tmp_table");
$yt_client->do_cmd(@command);
Utils::Sys::do_sys_cmd(
    $yt_client->get_cmd() . " get --path=$shards_tables[0]/\@_read_schema | " .
    $yt_client->get_cmd() . " set $tmp_table/\@_read_schema"
);
$yt_client->do_cmd('move', '--force', '--no-preserve-account', $tmp_table, $full_table);

release_file_lock();
exit(0);
