#!/usr/bin/python
import re

import sys
import os
import shutil
import datetime
from tempfile import mkstemp

import yt.wrapper as yt

def reduce(key, rows):
    result = {}
    for row in rows:
        result.update(row)
    if result.get('Categories') is not None:
        result['mctgs'] = result['Categories']
        del result['Categories']
    if result.get('@table_index') is not None:
        del result['@table_index']
    yield result

def main():
    banners_table = '//home/direct/export/bm/bm_banners'
    banners_categories_table = '//home/catalogia/banners-recategorized-fast'
    banners_extended_table = '<sorted_by=[bid]>//home/catalogia/banners_extended'

    yt.config['token_path'] = '/opt/broadmatching/bm-tokens/yt_plato'
    yt.config['spec_defaults'] = {
        'pool': 'catalogia',
    }
    yt.config["proxy"]["url"] = "hahn.yt.yandex.net"
    yt.run_reduce(
        reduce,
        [
            banners_table,
            banners_categories_table,
        ],
        banners_extended_table,
        reduce_by='bid',
        spec={
            'reducer': {
                'enable_input_table_index': True,
            },
        },
    )

if __name__ == '__main__':
    main()
