#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";

use Utils::Common;
use Utils::Sys;
use Utils::Hosts;
use Project;

Utils::Sys::get_file_lock() or exit(0);
Utils::Sys::handle_errors();

my $proj = Project->new({
    load_dicts              => 1,
    load_minicategs_light   => 1,
});

my $current_host = Utils::Hosts::get_curr_host();
my $shard_recategorized_file = $proj->banners_categories->{'shard_recategorized_file'}{$current_host}; 
$proj->banners_categories->send_to_direct($shard_recategorized_file);

Utils::Sys::release_file_lock();
