#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;

use Project;

use Utils::Sys qw/md5int/;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my $banner = $proj->bf->text2banner($line);
    my @categories = $banner->get_minicategs();
    my $execution_time = POSIX::strftime("%Y-%m-%d %H:%M:%S", localtime);
    print join("\t",
        $banner->id,
        $banner->campaign_id,
        $banner->group_id,
        $banner->bs_banner_id,
        $banner->lang,
        join('/', @categories),
        join(',', $banner->get_catalogia_flags()),
        join(',', $banner->get_minicategs_videodirectgroups_directids),
        join(',', grep{$_} map{md5int($_)} $banner->preprocess_title_body->get_mediagroups_for_categs([@categories])),
        $execution_time,
        join(',', grep{$_} map{$proj->categs_tree->get_minicateg_id($_)} @categories),
    ), "\n";
}
