#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;

use Project;

use Utils::Sys qw/md5int/;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my ($qid, $query) = split "\t", $line;
    print join("\t", $qid, $query, $proj->phrase($query)->get_core_subphrase), "\n";
}
