#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";

binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');
binmode(STDERR,':utf8');

use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";
use Utils::Sys qw/md5int/;
use List::Util qw(min);

use Getopt::Long;
use CatalogiaMediaProject;
use Project;
use Cmds::Mediaplanners;
use Data::Dumper;
use BM::PhraseCategs;
my $proj = CatalogiaMediaProject->new({
    no_form => 1,
    no_auth => 1,
    load_dicts => 1,
    load_minicategs_light => 1,
    nrmsrv => 0,
});
$proj->categs_tree->never_write_categs_cache(1);
$proj->categs_tree->never_read_categs_cache(1);


while (<STDIN>) {
    chomp;
    my $url = $_;
    my $categs = join('/', $proj->page($url)->get_minicategs());
    print "$url\t$categs\n";
    print STDERR "$url\t$categs\n";
}
