#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/../../../lib";

use Project;

use Utils::Common;
use Utils::Sys;

Utils::Sys::get_file_lock() or exit(0);
Utils::Sys::handle_errors();

my $proj = Project->new({});

my $tries = 5;
my $sleep_between_tries = 120;

my $yt_client = $proj->yt_client->set_params(
    pool                => 'catalogia',
    tries               => $tries,
    sleep_between_tries => $sleep_between_tries,
);

my $bytes_per_gigabyte = 1 << 30;
my $tmpfs_size = 8 * $bytes_per_gigabyte;
my $memory_limit = 8 * $bytes_per_gigabyte;
my $data_size_per_job = 20*(1<<20);

$yt_client->do_project_cmd(
    'map',
    "'./mr_perl ./categorize_banners_yt.pl'",
    "--local-file=$Utils::Common::options->{'dirs'}{'scripts'}/users/apovetkin/categorize_tskv/categorize_banners_yt.pl",
    "--src=//home/catalogia/tmp/spectskv",
    "--dst=//home/catalogia/tmp/spectskv_categorized",
    "'--input-format=<enable_escaping=false>dsv'",
    "'--output-format=<enable_escaping=false;columns=[BLTaskID;name;url;minicategs]>schemaful_dsv'",
    qq/'--spec={"mapper"={"tmpfs_path"="."; "copy_files"=true; "tmpfs_size"=$tmpfs_size; "memory_limit"=$memory_limit;};"data_size_per_job"=$data_size_per_job;}'/,
);

Utils::Sys::release_file_lock();
