#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;

use Project;

use Utils::Sys qw/md5int/;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my @params_arr = split /\t/, $line;
    my %params_hash;
    foreach (@params_arr) {
        my ($key, $value) = split /=/, $_, 2;
        $params_hash{$key} = $value;
    }
    
    my @minicategs = $proj->phrase($params_hash{'name'})->get_minicategs;
    print join( "\t",
        $params_hash{'BLTaskID'},
        $params_hash{'name'},
        $params_hash{'url'},
        join("/", @minicategs),
    ), "\n";
}
