#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use FindBin;
use lib "$FindBin::Bin/../../../lib";

use Project;
use Utils::Sys;
use Utils::Common;

Utils::Sys::handle_errors();

my $proj = Project->new({});

my $yt_client = $proj->yt_client->set_params(
    pool                => 'catalogia',
    tries               => 3,
    sleep_between_tries => 10,
);

my $src_table = '//home/catalogia/banners_extended{title,title_extension,body}';
my $dst_table = '//home/catalogia/tmp/check_delivery_pattern';

$yt_client->do_cmd(
    'map',
    "'./yt.pl'",
    "--local-file=$Utils::Common::options->{'dirs'}{'scripts'}/users/apovetkin/check_delivery_pattern/yt.pl",
    "'--src=$src_table'",
    "'--dst=$dst_table'",
    "'--input-format=dsv'",
    "'--output-format=dsv'",
    "'--spec={\"job_count\"=5000}'",
);
