#! /usr/bin/env perl

use utf8;
use open ':utf8';
use Digest::MD5 qw(md5_hex);
use Encode qw(encode_utf8);

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';

my $sample_percent = 10;
my %checksums = ();
while (my $line = <STDIN>) {
    next if int(rand(100)) > $sample_percent;
    chomp($line);
    my %h = map {$_->[0] => $_->[1]} map {[ split /=/, $_, 2 ]} split /\t/,$line;
    my $text = join(' ', $h{title}, $h{title_extension}, $h{body});

    $text =~ s/\\t/ /g;
    $text =~ s/\\n/ /g;

    next if length($text)> 500;

    my $old_dp = 0;
    my $new_dp = 0;

    my @matches = ();

    if ((@matches = $text =~ /(зака(?:з|жите|жи|зе)\s+(?:[А-Яа-я0-9]+\s+){0,2}(?:на сайте|онлайн|в\s+(?:[А-Яа-я0-9]+\s+)?онлайн|сейчас|с сайта)|интернет-магазин|онлайн[- ]?заказ)/i)
        || ((@matches = $text =~ /(доставк)/i) && $text !~ /в\s*(?:ближайшую)?\s*аптеку/i )
    ){
        $old_dp = 1;
    }

    @matches = ();

    if  ((@matches = $text =~ /(доставк)/i) && $text !~ /(доставк(?:[А-Яа-я]+))\sв\s*(?:перекресток|магазины|магазин|магазины\s*сети|бахетле|ашан|окей|карусель|билла|магнит|викторию|бехетле|дикси|магнолию|пятерочку|атак|азбуку\s*вкуса|(?:ближайшую)?\s*аптеку)/i )
    {
        $new_dp = 1;
    }

    if ( $old_dp + $new_dp == 1 ) {
        my $md5 = md5_hex(encode_utf8($h{body}));
        next if $checksums{$md5};
        $checksums{$md5} = 1;

        my %result = (
            old_dp => "$old_dp",
            new_dp => "$new_dp",
            text => $text,
        );
        print join("\t", map {$_ .'=' . $result{$_}} keys %result ), "\n";
    }
}
