#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";

binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');
use Storable qw(dclone);
use Data::Dumper;

my $cubes = {
    url1 => {
        cube1 => {title => 'title1', relevance => 1},
        cube2 => {title => 'title2', relevance => 4},
        cube3 => {title => 'title3', relevance => 2},
        cube4 => {title => 'title4', relevance => 8},
    },
    url2 => {
        cube2 => {title => 'title2', relevance => 4},
        cube3 => {title => 'title3', relevance => 3},
        cube4 => {title => 'title4', relevance => 8},
        cube5 => {title => 'title5', relevance => 3},
    },
    url3 => {
        cube3 => {title => 'title3', relevance => 6},
        cube4 => {title => 'title4', relevance => 3},
        cube5 => {title => 'title5', relevance => 2},
        cube6 => {title => 'title6', relevance => 6},
    },
};

print "Исходные данные\n";
print Data::Dumper->Dumper($cubes), "\n";

print "Лучшая полнота\n";
filter_cubes(dclone($cubes));

sub filter_cubes {
    my $cubes = shift;
    my $best_rel = {};
    my $urlcount = {};
    foreach my $url (keys %$cubes) {
        foreach my $cube ( keys %{$cubes->{$url}} ) {
            $best_rel->{$cube} //= $cubes->{$url}{$cube}{relevance};
            $best_rel->{$cube} = $cubes->{$url}{$cube}{relevance} if $best_rel->{$cube} < $cubes->{$url}{$cube}{relevance};
            $urlcount->{$cube}++;
        }
    }

    # Если раскомментировать этот код, алгоритм будет максимизировать релевантность. Без него он максимизирует полноту по урлам
    #foreach my $url (keys %$cubes) {
    #    foreach my $cube ( keys %{$cubes->{$url}} ) {
    #        if ($best_rel->{$cube} > $cubes->{$url}{$cube}{relevance}) {
    #            delete $cubes->{$url}{$cube};
    #            $urlcount->{$cube}--;
    #        }
    #    }
    #}

    #жадный алгоритм удаления дублей, максимизирующий полноту по урлам
    #удаляем кубики по одному, пока не уберутся все повторы кубиков
    #после любого удаления переходим к следующему кубику
    while ( grep {$urlcount->{$_} > 1} keys %$urlcount ) {
        foreach my $cube ( grep {$urlcount->{$_} > 1} keys %$urlcount ) {
            my $next = 0;
            my $mincubecount;
            foreach my $url (keys %$cubes) {
                next unless exists $cubes->{$url}{$cube};
                my $cubecount = scalar keys %{$cubes->{$url}};
                $mincubecount //= $cubecount;
                $mincubecount = $cubecount if $mincubecount > $cubecount;
            }
            # удаляем повторы кубиков у тех урлов, у которых больше кубиков
            foreach my $url (keys %$cubes) {
                next unless exists $cubes->{$url}{$cube};
                my $cubecount = scalar keys %{$cubes->{$url}};
                if ($cubecount > $mincubecount && exists $cubes->{$url}{$cube}) {
                    delete $cubes->{$url}{$cube};
                    $urlcount->{$cube}--;
                    $next = 1;
                    last;
                }
            }
            next if $next;
            my $has_cube = 0;
            my $max_relevance = 0;
            #удаляем повторы кубиков, у которых не максимальная релевантность
            foreach my $url (keys %$cubes) {
                $max_relevance = $cubes->{$url}{$cube}{relevance} if exists $cubes->{$url}{$cube} && $cubes->{$url}{$cube}{relevance} > $max_relevance;
            }
            foreach my $url (keys %$cubes) {
                next unless exists $cubes->{$url}{$cube};
                if ( exists $cubes->{$url}{$cube} && $cubes->{$url}{$cube}{relevance} < $max_relevance ) {
                    delete $cubes->{$url}{$cube};
                    $urlcount->{$cube}--;
                    $next = 1;
                    last;
                }
            }
            next if $next;
            #окончательно удаляем все дубли, кроме одного, если по всем остальным критериям удалить не получается
            foreach my $url (keys %$cubes) {
                next unless exists $cubes->{$url}{$cube};
                if ( $has_cube && exists $cubes->{$url}{$cube} ) {
                    delete $cubes->{$url}{$cube};
                    $urlcount->{$cube}--;
                    $next = 1;
                    last;
                }
                elsif ( exists $cubes->{$url}{$cube} ) {
                    $has_cube = 1;
                }
            }
            next if $next;
        }
    }
}
