#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";

binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');


use FindBin;
use lib "$FindBin::Bin/../../../../lib";
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";

use Getopt::Long;
use CatalogiaMediaProject;
use Cmds::Mediaplanners;
use Data::Dumper;
use Project;
use Utils::TailsDistribution;

require Project;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
});

my $nf = $proj->new_features2;
my @dssm_models = $nf->traffic_nativity_dssm_models;
print join("\t", "phrase1", "phrase2", @dssm_models)."\n";

while(<STDIN>) {
    chomp;
    my ($phr1, $phr2) = map {$proj->phrase($_)} split /,/,$_;
    my @cosine;
    push @cosine,  $nf->_phrases_cosine($phr1, $phr2, $_) foreach @dssm_models;
    print join("\t", "$phr1", "$phr2", @cosine)."\n"; 
}
