#!/usr/bin/perl -w
use warnings;
use FindBin;
use strict;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";


use Project;

use utf8;
use open ":utf8";


my $proj = Project->new({
load_dicts => 1,
load_minicategs_light => 1,
});

my @categs = $proj->categs_tree->get_minicategs_list;

foreach my $categ ( @categs ) {
    foreach my $lang ( keys %{$proj->languages} ) {
        my $phrases = join (',', $proj->languages->{$lang}->get_category_raw_phrases($categ));
        print "$lang\t$categ\t$phrases\n";
    }
}
