#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";

binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');


use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";

use Getopt::Long;
use Data::Dumper;
use CGI;
use FCGI::ProcManager;
use CGI::Fast;

use Project;
use Utils::Urls qw(url_to_punycode);
use Utils::Sys qw(split_csv_line);



use Utils::Regions;

        my $proj = Project->new({
            load_dicts => 1,
        });


#купить слона/213,219
while(<STDIN>) {
    chomp;
    my ($text, $geo) = split /\//;
    $geo = [split /,/, $geo];
    my $subtree = [ Utils::Regions::geobase_subtree($geo) ];
    my $phrase = $proj->phrase($text);
    my $freq_all = $phrase->get_search_count();
    my $freq_geo = $phrase->get_search_count($subtree, is_subtree => 1);
    my $count_geo = scalar(@$subtree);
    if ($freq_all < 100 && $freq_geo < 5 && $count_geo < 20000) {
        print "bad $freq_all $freq_geo $count_geo\n";
    }
    else {
        print "good $freq_all $freq_geo $count_geo\n";
    }
}

