use strict;
use warnings;

my @files = split /\n/, `find /opt/broadmatching/temp/dyn_banners -name '201808*task.err'`;

my $threshold = 1000;

$| = 1;

foreach my $file (@files) {
    open F, "< $file" or next;
    my $mem = 0;
    my $prevline = '';
    while (my $line = <F>) {
        chomp $line;
        my (undef, undef, $memfield) = split /\t/, $line;
        $line = "$file\t$line";
        next unless $memfield && $memfield =~ /MEM/;
        $memfield =~ s/\D//g;
        $memfield = $memfield + 0;
        if ( $mem && $memfield - $mem > $threshold ) {
            print "$prevline\n$line\n\n";
        }
        $mem = $memfield;
        $prevline = $line;
    }
    close F;
}

