#! /usr/bin/env perl

use utf8;

use lib 'scripts/lib';

use Project;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my $banner = $proj->bf->text2banner($line);
    if ($banner->title_body_phr->is_porno_phrase) {
        my $pw = join( ",",  map { join(' --> ', @$_) } $banner->title_body_phr->get_porno_words);
        my $str = join("\t",
            $banner->id,
            $banner->title_body_phr->text,
            $pw,
        );
        print "$str\n";
    }
}
exit 0;
