#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";
 
binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');

 
use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";
use Utils::Sys qw/md5int/;
use List::Util qw(min);

use Getopt::Long;
use CatalogiaMediaProject;
use Project;
use Cmds::Mediaplanners;
use Data::Dumper;
use BM::PhraseCategs;
use Utils::Urls qw(normalize_url);
use Utils::Words qw(stop4norm);

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});

my $cubes = {};
my $i = 0;
while (<STDIN>) {
    chomp;
    my ($phrase, $cube, $minus) = split /\t/, $_;
    my $norm = "".$proj->phrase($phrase)->norm_phr;
    unless (exists $cubes->{$cube}{minus} ) {
        my @minus = map {$proj->phrase($_)->norm_phr} map {$_ =~ s/^[-]//r} split /\s+/, $minus;
        $cubes->{$cube}{minus}{$_} = 1 foreach @minus;
    }
    $cubes->{$cube}{phrases}{$norm} = 1;
    print STDERR "$phrase\t$i\n";
    $i++;
}
   
foreach my $cube (keys %$cubes){
    my $phrases = join ',', grep {$_} keys %{$cubes->{$cube}{phrases}};
    my $minus = join ',', grep {$_} keys %{$cubes->{$cube}{minus}};
    my $categs =  $proj->phrase_list($phrases)->get_phrases_categs_hashref;
    my ($categ) = sort {$categs->{$b} <=> $categs->{$a}} grep {$_} grep {grep{$_ eq 'Мебель'} ($_, $proj->categs_tree->get_cat_path($_))} keys %$categs;
    print join("\t", $categ, $cube, $phrases, $minus), "\n" if defined $categ;
}

