#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";

binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');


use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";

use Getopt::Long;
use Data::Dumper;

use Utils::Words;

use Project;

use StaticMap;

my $proj = Project->new({
        load_dicts => 1,
    });


my $heads = StaticMap->new('/home/apovetkin/harmonization_headclusters');
my $tails = StaticMap->new('/home/apovetkin/harmonization_tailclusters');

print "\n--------------READY--------------\n";

while (<STDIN>) {
    chomp;
    my $row = $_;

    my ($rhead, $rtail) = split /:/, $row;
    my $clusterid = $heads->Value($rhead);
    my $norm = $proj->phrase($rtail)->norm_phr;
    my $tail = $rtail ? $tails->Value("$clusterid:$norm") : $clusterid;
    print "$rhead => $tail\n";
}
