#!/usr/bin/perl
use strict;

use utf8;
use open ":utf8";

use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";
use Utils::Common;
use Utils::Words;
use Utils::Sys qw/
    get_file_lock
    release_file_lock
    handle_errors
    dir_files
    modtime
    md5int
    load_json
/;
use CatalogiaMediaProject;
use BM::Phrase;

use POSIX qw(strftime);
use DBI;
use Data::Dumper;
use LWP::UserAgent;
use JSON::XS;
use Encode;

get_file_lock() or exit(0);
handle_errors();

my @used_languages = qw(ru en tr);
my $proj = CatalogiaMediaProject->new({
    no_auth                 => 1,
    no_form                 => 1
});

my $date = strftime "%Y-%m-%d", localtime(time - 24 * 3600);
my $json = JSON::XS->new;
my $ua = LWP::UserAgent->new();
$ua->timeout(300);
for my $day ( 1..90 ) {
    for my $hour (0..23) {
        for my $min (0..9) {
            my $date = strftime "%Y-%m-%d", localtime(time - 24 * 3600 * $day );
            my $hour_str = sprintf "%02d", $hour;
            my $min_strfrom = sprintf "%02d", $min * 6;
            my $min_strto = sprintf "%02d", ($min+1)*6 -1;
            my $post = "{\"params\":[\"$date $hour_str:$min_strfrom:00\",\"$date $hour_str:$min_strto:59\"],\"version\":\"1.1\",\"id\":1,\"method\":\"exportBannersFixedFlags\"}";
            my $resp = $ua->post("http://9048.ppcmoddev2.yandex-team.ru/jsonrpc/", Content => $post);
            if(!$resp->is_success) {
                $proj->log("ERROR: ".$resp->status_line);
                next;
            }

            my $data = $json->decode(Encode::decode_utf8($resp->decoded_content));
            print scalar @{$data->{result}}, "\n"; next;
            for my $item (@{$data->{result}}) {
                $item->{timestamp} = "$date $hour_str:00:00";
                foreach (keys %$item) {
                    $item->{$_} =~ s/\n//g;
                    $item->{$_} =~ s/\t//g;
                }
                print join("\t", map{"$_=$item->{$_}"} keys %$item), "\n";
            }
            print STDERR $post;
        }
    }
}
exit(0);

