#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";

binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');


use FindBin;
use lib "$FindBin::Bin/../../lib";

use Project;

my $proj = Project->new({
    load_dicts => 1,
    load_minicategs_light => 1,
});

while (<STDIN>) {
    chomp;
    my $page = $proj->page($_);
    my @categs = $page->get_minicategs;
    my @flags = $proj->categs_tree->get_catalogia_flags(@categs);
    my $categs_str = join('/', sort @categs);
    my $flags_str = join(',', sort @flags);
    print "$_\t$categs_str\t$flags_str\n";
}
