#!/usr/bin/perl -w
use strict;
use warnings;
use utf8;
use open ":utf8";

binmode(STDIN,':utf8');
binmode(STDOUT,':utf8');


use FindBin;
use lib "$FindBin::Bin/../../../../lib";
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";

use Getopt::Long;
use CatalogiaMediaProject;
use Cmds::Mediaplanners;
use Data::Dumper;

use Utils::TailsDistribution;

my $proj = CatalogiaMediaProject->new({
    load_dicts => 1,
    load_minicategs_light => 1,
    memlog => 1,
    no_auth => 1,
    no_form => 1,
    nrmsrv => 0,
});

    $proj->categs_tree->never_write_categs_cache(1);
    $proj->categs_tree->never_read_categs_cache(1);
while(1){
    my @rb = split ",", $proj->random_banners_client->k_random_banners(1000);
    my $bnl = $proj->bf->_ids2bnl(\@rb);
    
    for my $bnr (@$bnl) {
        my $text = $bnr->title_body_phr;
        my $pftext = $bnr->preprocess_title_body;
        my $flags = join ',', sort $proj->categs_tree->get_catalogia_flags($text->get_minicategs);
        my $pfflags = join ',', sort $proj->categs_tree->get_catalogia_flags($pftext->get_minicategs);
        print "$text\t$flags\t$pftext\t$pfflags\n";
    }

}
