# -*- coding: utf-8 -*-

from yabs.tabtools import mr_do_aggregate, StatAggregator, Sum, First, Grep, Count
from yabs.tabutils import TemporaryTableWithMeta
from mapreducelib import MapReduce


def aggregate(src_tables, dst_table):

    with TemporaryTableWithMeta() as tmp:

        mr_do_aggregate(
            aggregator=StatAggregator(
                reducers=[
                    Sum('Clicks', 'Clicks'),
                    Sum('Shows', 'Shows'),
                    Sum('VClicks', 'VClicks'),
                    Sum('SClicks', 'SClicks'),
                    Sum('LClicks', 'LClicks'),
                    Sum('D120', 'D120'),
                    Sum('Depth', 'Depth'),
                    Sum('Duration', 'Duration'),
                    Sum('Cost', 'Cost'),
                    Sum('VCost', 'VCost'),
                    First('OrigPhrase', 'OrigPhrase'),
                    First('BroadPhrase', 'BroadPhrase')
                ],
                keys=['BannerID', 'OrigPhraseID', 'BroadPhraseID']
            ),
            premap=[
                Grep('r.TypeID == 2')
            ],
            src_tables=src_tables,
            dst_tables=[tmp.name]
        )

        mr_do_aggregate(
            aggregator=StatAggregator(
                reducers=[
                    Count('BannerCount'),
                    Sum('Clicks', 'Clicks'),
                    Sum('Shows', 'Shows'),
                    Sum('VClicks', 'VClicks'),
                    Sum('SClicks', 'SClicks'),
                    Sum('LClicks', 'LClicks'),
                    Sum('D120', 'D120'),
                    Sum('Depth', 'Depth'),
                    Sum('Duration', 'Duration'),
                    Sum('Cost', 'Cost'),
                    Sum('VCost', 'VCost'),
                    First('OrigPhrase', 'OrigPhrase'),
                    First('BroadPhrase', 'BroadPhrase')
                ],
                keys=['OrigPhraseID', 'BroadPhraseID']
            ),
            src_tables=[tmp.name],
            dst_tables=[dst_table]
        )


if __name__ == '__main__':

    src_tables = MapReduce.getTables(prefix='users/stys/broadmatch/slotstat/slotstat201603')
    dst_table = 'users/stys/broadmatch/slotstat201603.aggr'
    aggregate(src_tables, dst_table)