# -*- coding: utf-8 -*-

from yabs.threadpool import ThreadManager
from datetime import datetime, timedelta
from slotstat import build_slot_stat_table, source_log_regexp, default_orig_phrase_table
from yabs.logconfig import get_logs_regexp_time
from argparse import ArgumentParser


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('-s', '--start', required=True)
    parser.add_argument('-f', '--finish', required=True)
    parser.add_argument('-p', '--orig-phrase-table', default=default_orig_phrase_table)
    parser.add_argument('-t', '--threads', default=10)
    parser.add_argument('-d', '--dst', default='users/stys/broadmatch/slotstat/slotstat%Y%m%d')
    args = parser.parse_args()

    dates = []
    current_date = datetime.strptime(args.start, '%Y%m%d').date()
    finish_date = datetime.strptime(args.finish, '%Y%m%d').date()
    while current_date <= finish_date:
        dates.append(current_date)
        current_date = current_date + timedelta(days=1)

    def task(date):
        date_start = date.strftime('%Y%m%d')
        date_finish = (date + timedelta(days=1)).strftime('%Y%m%d')
        src_tables = sorted(t['name'] for t in get_logs_regexp_time(source_log_regexp, date_start, date_finish))
        dst_table = date.strftime(args.dst)
        build_slot_stat_table(src_tables, dst_table, orig_phrase_table=args.orig_phrase_table)

    manager = ThreadManager(count=args.threads)

    for date in dates:
        manager.addJob(task, date)

    manager.startWorkers()
    manager.waitWorkers()
    manager.stopWorkers()
