#!/usr/bin/python
# -*- coding: utf-8 -*-

import yt.wrapper as yt


def reducer(key, recs):
    S = set()
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            S.add(rec['text'])
        else:
            del rec['host']
            del rec['region_id']

            L = list(S)
            L.sort()

            text = '\t'.join(L)
            rec['text'] = text

            yield rec


def main():
    input_1 = '//home/catalogia/yuryz/links'
    input_2 = '//home/webmaster/prod/export/catalogia/queries'
    output = '//home/catalogia/yuryz/queries_left_join'

    yt.run_reduce(reducer, [input_1, input_2], output, reduce_by = 'url')
    yt.run_sort(output, sort_by=['domain', 'url', 'position'])
    #yt.run_sort('//home/catalogia/yuryz/queries_left_join', '//tmp/yuryz/queries_left_join', sort_by=['domain', 'url', 'position'])

    print yt.row_count(input_1)
    print yt.row_count(input_2)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
