package BM::Banners::LBannerNeighbors;
use strict;

use utf8;
use open ':utf8';

use std;
use base qw(ObjLib::ProjPart);


########################################################
# Инициализация
########################################################

sub init {
}


########################################################
#Методы
########################################################

my $bad_categs = qr/(курьерские услуги|поиск работы|Вакансия|продвижение сайтов|Подарки, сувениры, цветы|Услуги базаров, рынков|Серверы|Реклама в интернете|Сырье, концентраты|NCAP Автомобили малого класса|Скидочные купоны)/;


#--- категоризация по landing page и ближайшим соседям ---
sub get_categs_neighbors {
    my ( $self ) = @_;

    my $proj = $self->proj;
    my $bid = $self->id;
    my $btext = $self->banner_text_phrase->text;
    my $burl = $self->url;

    my @categs = $proj->page($burl)->get_minicategs; #категоризация по landing page
    if (@categs) {
        my @categs2;
        for my $categ (@categs) {
            unless ($categ =~ /${bad_categs}$/) {
                push @categs2, $categ;
            } else {
                my @tmp = $self->categ_neighbors($bid, $btext); #категоризация по ближайшим соседям
                push @categs2, @tmp if @tmp;
            }
        }
        @categs = @categs2;
    } else {
        @categs = $self->categ_neighbors($bid, $btext); #категоризация по ближайшим соседям
    }

    if (@categs) {
        @categs = $self->ancestors_add(\@categs); #добавление предков для категорий
        @categs = sort @categs;
        my @categs2;
        for my $i (0..$#categs) {
            next if $i < $#categs && $categs[$i+1] =~ /^$categs[$i]/; #вхождение категорий одна в другую или дублирование
            my @temp = split m{/}, $categs[$i];
            push @categs2, $temp[$#temp]; #последняя ветвь
        }
        return @categs2;
    }
    return ();
}


#--- добавление предков для категорий ---
sub ancestors_add {
    my ($self, $categs) = @_;

    my @categs_ancestors;
    for my $categ (@$categs) {
        my @ancestors; #все предки категории
        my $ancestor = $categ;
        while ($ancestor = $self->proj->categs_tree->get_minicateg_parent($ancestor)) {
            push @ancestors, $ancestor;
        }
        push @categs_ancestors, join("/", reverse @ancestors)."/$categ";
    }

    return @categs_ancestors;
}


#--- категоризация по ближайшим соседям ---
sub categ_neighbors {
    my ($self, $bid, $btext) = @_;

    my $bnr = $self->proj->bf->get_banner_by_id($bid);
    return () unless defined ($bnr);

    my $campaign = $bnr->campaign_obj;
    return () unless defined ($campaign);

    my $campaign_bnl = $campaign->bnl;
    return () unless defined ( $campaign->bnl );

    my @banners = sort { $a->id cmp $b->id } @{$campaign_bnl};
    my ($ind_up, $ind_down) = bin_search($bid, \@banners); #ближайшие соседи

    my ($text_up, @categs_up) = $self->sel_categs_neighbor($ind_up, \@banners, -1); #верхний сосед
    my ($text_down, @categs_down) = $self->sel_categs_neighbor($ind_down, \@banners, +1); #нижний сосед

    #присвоение категорий соседей
    my @bcateg;
    if (@categs_up && @categs_down) {
        if (join("\t", @categs_up) eq join("\t", @categs_down)) {
            @bcateg = @categs_up;
        } else {
            my $simil_up = bnrs_simil_lev($btext, $text_up);
            my $simil_down = bnrs_simil_lev($btext, $text_down);
            @bcateg = $simil_up >= $simil_down ? @categs_up : @categs_down;
        }
    } elsif (@categs_up && !@categs_down) {
        @bcateg = @categs_up;
    } elsif (!@categs_up && @categs_down) {
        @bcateg = @categs_down;
    }

    return @bcateg;
}


#--- бинарный поиск ближайших категоризованных баннеров в кампании ---
sub bin_search
{
    my ($bid, $banners) = @_; #$bid - ID баннера; $banners - отсортированный по ID список баннеров из одной кампании
    
    my $first = 0;
    my $last = $#{$banners};
    while ($first <= $last) {
        my $mid = $first + int(($last - $first) / 2);
        if ($bid lt $$banners[$mid]->id) {
            $last = $mid - 1;
        } elsif ($bid gt $$banners[$mid]->id) {
            $first = $mid + 1;
        } else { #совпадение
            $last = $mid - 1;
            $first = $mid + 1;
            last;
        }
    }
    
    $last = 0 if $last < 0;
    $first = $#{$banners} if $first > $#{$banners};

    return ($last, $first);
}


#--- выбор категорий соседа ---
sub sel_categs_neighbor {
    my ($self, $ind, $banners, $dir) = @_; #$dir - направление: -1 - вверх, +1 - вниз

    my @categs;
    while ($dir < 0 && $ind >= 0 || $dir > 0 && $ind <= $#{$banners}) {
        return () unless defined ($$banners[$ind]);

        @categs = $self->proj->phrase($$banners[$ind]->banner_text_phrase->text)->get_minicategs;

        my @categs2;
        for my $categ (@categs) {
            unless ($categ =~ /${bad_categs}$/) {
                push @categs2, $categ;
            }
        }
        @categs = @categs2;
        last if @categs;
        $ind += $dir;
    }

    if ($ind >= 0 && $ind <= $#{$banners}) {
        return ($$banners[$ind]->banner_text_phrase->text, @categs);
    }
    return ();
}


#--- определение сходства текстов баннеров ---
sub bnrs_simil_lev {
    my ($bnr1_text, $bnr2_text) = @_;

    $bnr1_text = bnr_text_clean($bnr1_text);
    $bnr2_text = bnr_text_clean($bnr2_text);

    return 1-levenshtein($bnr1_text, $bnr2_text)/(length($bnr1_text)+length($bnr2_text));
}


#--- очистка текста баннера ---
sub bnr_text_clean {
    my ($bnr_text) = @_;

    my $valid_chars = qr/0-9a-zа-яё \-/; #допустимые символы
    
    $bnr_text = lc($bnr_text);
    $bnr_text =~ s/[^$valid_chars]/ /g;
    $bnr_text =~ s/^ +//;
    $bnr_text =~ s/ +$//;
    $bnr_text =~ s/ +/ /g;
    
    return $bnr_text;
}


#--- редакционное расстояние ---
sub levenshtein
{
    my ($a, $b)=@_;

    my @bellman;
    my $la=length $a;
    my $lb=length $b;

    $bellman[$_][0]=$_ for 0..$la;
    $bellman[0][$_]=$_ for 0..$lb;

    for my $j(1..$lb)
    {
        for my $i(1..$la)
        {
            $bellman[$i][$j]=$bellman[$i-1][$j]+1;
            $bellman[$i][$j]=$bellman[$i][$j-1]+1
                if $bellman[$i][$j]>$bellman[$i][$j-1]+1;

            if(substr($a, $i-1, 1) eq substr($b, $j-1, 1))
            {
                $bellman[$i][$j]=$bellman[$i-1][$j-1]
                    if $bellman[$i][$j]>$bellman[$i-1][$j-1];
            }
        }
    }
    return $bellman[$la][$lb];
}


1;


