#!/usr/bin/python
# -*- coding: utf-8 -*-

#расчет статистики доменов - этап 1 (добавление специального суффикса)

import yt.wrapper as yt
import re


def mapper(rec):
    suff = rec['@row_index'] % 10
    yield {'domain': rec['domain'], 'url': rec['url'], 'suff': suff, '@row_index': rec['@row_index']}


def main():
    input = '//tmp/yuryz/queries_join_index'
    output = '//tmp/yuryz/domain_stat_1'

    yt.run_map(mapper, input, output)
    yt.run_sort(output, sort_by=['domain', 'url', 'suff', '@row_index'])

    print yt.row_count(input)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
