#!/usr/bin/python
# -*- coding: utf-8 -*-

#расчет статистики доменов - этап 2 (предварительное суммирование)

import yt.wrapper as yt


def reducer(key, recs):
    index_min = -1 #индекс начала урла в домене
    domain_size = 0
    for rec in recs:
        if index_min < 0:
            index_min = rec['@row_index']
        domain_size += 1

    yield {'domain': key['domain'], 'url': key['url'], 'index_min': index_min, 'domain_size': domain_size}


def main():
    input = '//tmp/yuryz/domain_stat_1'
    output = '//tmp/yuryz/domain_stat_2'

    yt.run_reduce(reducer, input, output, reduce_by=['domain', 'url', 'suff'])
    yt.run_sort(output, sort_by=['domain', 'url', 'index_min'])

    print yt.row_count(input)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
