#!/usr/bin/python
# -*- coding: utf-8 -*-

#поиск и печать записей домена

import sys
import re
import math

import yt.wrapper as yt


#--- печать записей домена ---
def domain_print(table, domain_search, pos_max, recs_max):
    input = table #исходная таблица
    pos_max = int(pos_max)
    recs_max = int(recs_max)

    rec_count = 0
    rec_print = 0 #число печатаемых записей

    input_range = input + '["' + domain_search + '"]' #выбор ВСЕХ записей домена
    for rec in yt.read_table(input_range, raw=False):
        domain = rec['domain']
        if domain != domain_search:
            break

        if rec['position'] <= pos_max:
            rec['clicks'] += 1 #сглаживание по Лапласу (Laplace/Additive smoothing)
            if rec['clicks'] > 0: #ФИЛЬТР
                rec_print += 1
                rec['title'] = rec['title'].replace('\t', ' ')
                print rec['url'] + '\t' + str(rec['position']) + '\t' + rec['query'] + '\t' + str(rec['clicks']) + '\t' + str(1) + '\t' + rec['title']

        rec_count += 1
        if rec_count % 10000 == 0:
            sys.stderr.write('%10d\r' % (rec_count))
        if recs_max != -1 and rec_count > recs_max:
            break

    return rec_print


def main():
    input = '//home/catalogia/yuryz/queries_join_index' #исходная таблица

    #--- Печать записей домена ---
    recs_max = -1 #печатать все записи
    rec_count = domain_print(input, sys.argv[1], sys.argv[2], recs_max) #sys.argv[1] - домен, sys.argv[2] - MAX позиция запроса в выдаче, recs_max - MAX число записей в выдаче
    print >>sys.stderr, 'Напечатано ' + str(rec_count) + ' записей домена'


if __name__ == '__main__':
    main()
