#!/usr/bin/python
# -*- coding: utf-8 -*-

#поиск статистики домена

import sys
import re
import math

import yt.wrapper as yt


#--- progress bar ---
def progress(count, total, status=''):
    bar_len = 50
    filled_len = int(round(bar_len * count / float(total)))

    percents = round(100.0 * count / float(total), 1)
    bar = '■' * filled_len + '-' * (bar_len - filled_len)

    sys.stderr.write('[%s] %s%s ...%s\r' % (bar, percents, '%', status))
    sys.stderr.flush()


#--- поиск начала домена в таблице ---
def domain_search(table, domain_search):
    input = table #исходная таблица
    row_count = yt.row_count(input)

    low = 0
    hi = row_count - 1
    steps = int(math.ceil(math.log(row_count, 2))) + 1 #число итераций в бинарном поиске
    step = 0;
    while low <= hi: #бинарный поиск урла в таблице
        mid = int((low + hi) / 2)
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор

        step += 1
        #------------------------------------------------
        progress(step, steps, status = 'Поиск в таблице')
        #------------------------------------------------

        if domain_search < rec['domain']:
            hi = mid - 1
        elif domain_search > rec['domain']:
            low = mid + 1
        else: #совпадение
            break

    print >>sys.stderr

    if low <= hi: #поиск успешный
        return mid #индекс найденной записи в таблице
    else:
        return -1


def main():
    input = '//home/catalogia/yuryz/domain_incr' #исходная таблица

    ind = domain_search(input, sys.argv[1]) #бинарный поиск в таблице (sys.argv[1] - домен)
    if ind >= 0: #успешный поиск
        input_rec = input + '[#' + str(ind) + ':#' + str(ind+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_rec, raw=False)) #итератор
        print str(ind) + '\t' + rec['domain'] + '\t' + str(rec['domain_size']) + '\t' + str(rec['url_count'])
    else:
        print >>sys.stderr, 'Поиск неудачный :('


if __name__ == '__main__':
    main()
