#!/usr/bin/perl -w
#печать счетчика запросов из cdict

use strict;
use utf8;

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

binmode(STDIN, ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my $proj = Project->new();

my $size = (stat(STDIN))[7]; # $size > 0, если в STDIN реальный файл (это его размер), и $size == 0, если ввод с клавиатуры

my $flag = 0;
while (<STDIN>) { #результат print_tabl.py (e.g., домен babadu_tab)
    progress(tell(STDIN), $size, "Добавление search_count");
    chomp;
    if (/^QUERIES:$/) {
        $flag = 1;
    } elsif ($flag == 1) {
        if (/^\t/) {
            my ($tab, $pos, $query, $freq) = split /\t/;
            my $search_count = $proj->phrase($query)->get_search_count;
            $_ .= "\t$search_count";
        } else {
            $flag = 0;
        }
    }
    print "$_\n";
}
print STDERR "\n";


#--- progress bar ---
sub progress {
    my ($count, $total, $status) = @_;
    my $bar_len = 50;
    my $filled_len = int(sprintf("%.f", $bar_len * $count / $total));

    my $percents = sprintf "%.1f", 100.0 * $count / $total;
    my $bar = ('■' x $filled_len).('-' x ($bar_len - $filled_len));

    my $status_len = 70;
    my $msg = substr($status, 0, $status_len);
    my $msg_len = length($msg);
    $msg = $msg_len < $status_len ? $msg.(' ' x ($status_len - $msg_len)) : $msg;
    printf STDERR "[%s] %s%s ...%s\r", $bar, $percents, '%', $msg;
    #STDERR->flush();
}
